/**
* \file: app_iface_intern.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_APP_IFACE_APP_IFACE_INTERN_H
#define AAM_APP_IFACE_APP_IFACE_INTERN_H

#include "model/device.h"
#include "model/partition.h"
#include "app_iface/socket_server.h"

//------------------------------ abstract members (need to be implemented by the concrete API impl ---

error_code_t app_iface_init_impl(void);

void app_iface_handle_message(connection_ctx_t *connection);

void app_iface_deinit_impl(void);

//----------------------------------------------------------------------------------------------------


//------------------------------ API members ---------------------------------------------------------

error_code_t app_iface_init(void);

void app_iface_deinit(void);

//----------------------------------------------------------------------------------------------------


//------------------------------ signals called from internally (mainly the FSMs) --------------------
void app_iface_signal_device_detected(device_t *device);

void app_iface_signal_device_nomedia(device_t *device);

void app_iface_signal_device_automounting(device_t *device);

void app_iface_signal_device_automounted(device_t *device);

void app_iface_signal_device_unmounting(device_t *device);

void app_iface_signal_device_unmounted(device_t *device);

void app_iface_signal_device_invalid(device_t *device);


void app_iface_signal_partition_detected(partition_t *partition);

void app_iface_signal_partition_unsupported(partition_t *partition);

void app_iface_signal_partition_mounting(partition_t *partition);

void app_iface_signal_partition_mounted(partition_t *partition);

void app_iface_signal_partition_mount_err(partition_t *partition);

void app_iface_signal_partition_remounting(partition_t *partition);

void app_iface_signal_partition_unmounting(partition_t *partition);

void app_iface_signal_partition_unmounted(partition_t *partition);

void app_iface_signal_partition_invalid(partition_t *partition);

//----------------------------------------------------------------------------------------------------

#endif
